      INCLUDE 'FLIB.FI'     ! FOR USE WITH MICROSOFT FORTRAN ONLY
      PROGRAM DNA
C
C =====================================================================
C I                                                                   I
C I                                                                   I
C I                           =============                           I
C I                           --- D N A ---                           I
C I                           =============                           I
C I                                                                   I
C I                     DAMAGE NONLINEAR ANALYSIS                     I
C I                               FOR                                 I
C I                  ELASTO-PLASTC MATERIAL BEHAVIOR                  I
C I                                                                   I
C I   SCOPE OF PROGRAM:                                               I
C I                                                                   I
C I   ANALYISIS OF STRESSES, STRAINS AND DEFORMATIONS INDUCED ON      I
C I   AN ELASTO-PLASTIC SOLID CONTINUUM AS THE RESULT OF VARIOUS      I
C I   FORCE OR DISPLACEMENT LOADINGS INCLUDING THE EFFECT OF DAMAGE.  I
C I                                                                   I
C I   NOTE: THIS PROGRAM ASSUMES A STRESS VECTOR ORDERED AS           I
C I       FOR 3D ELEMENTS:                                            I
C I          {SIGMA} = {SIGMA11,SIGMA22,SIGMA33,SIGMA12,              I
C I                     SIGMA23,SIGMA13}                              I
C I       FOR 2D PLANE STRESS AND PLANE STRAIN ELEMENTS:              I
C I          {SIGMA} = {SIGMA11,SIGMA22,SIGMA12}                      I
C I       AND FOR AXISYMMETRIC ELEMENTS:                              I
C I          {SIGMA} = {SIGMA11,SIGMA22,SIGMA33,SIGMA12)              I
C I                                                                   I
C I                                                                   I
C I                                                                   I
C =====================================================================
C
      IMPLICIT NONE
      INCLUDE 'FLIB.FD'     ! FOR USE WITH MICROSOFT FORTRAN ONLY
      INTEGER MAX_NODES,MAX_STORAGE,MNNDF,MAX_NODES_DOF
      PARAMETER (MAX_NODES=3000,MAX_STORAGE=300000,MNNDF=3,
     .           MAX_NODES_DOF=MAX_NODES*MNNDF)
      INTEGER IDIM,I_IN,LFGLEN,NELEM,NTDF,IEXT,IRES,I_OUT,I_GRAPH
      INTEGER LDEV,LDEV1,LDEV2,LDEV3,LDEV4,LDEVST,IFILEN,INCREMENTS
      INTEGER ITERATIONS,LFOLEN,MBAND,NINODE,NNDF,NNODES,NTSK
      INTEGER STR$COLLAPSE,STR$FIND_FIRST_IN_SET_R
      INTEGER GRAPHICS_INTR,OUTPUT_INTR,IDOF(MAX_NODES_DOF),
     .        JDIAG(MAX_NODES),NUMARGS
      CHARACTER*60 IN_FN,OUT_FN,GRAPH_FN,RESPONSE*6,FILESTAT*6
      LOGICAL DELETE,LINEAR,RESTART,SYMMETRIC,GRAPHICS_OUT
C      THE FOLLOWING TWO LINES ARE FOR USE WITH MIRCRSOFT FORTRAN ONLY
      INTEGER*2 IYR,IMON,IIDAY,IFDAY,IHOUR,IMIN,ISEC,IHSEC,ARGSTAT
      REAL*4 INITIAL_TIME,FINAL_TIME,SOLUTION_TIME
C     INTEGER ISOLTIME,IARGC,MCLOCK   ! UNIX XL FORTRAN
      REAL*8 R(MAX_NODES),SKG,SKGL
      COMMON/DEVICE/LDEV1,LDEV2,LDEV3,LDEV4,LDEV,LDEVST
      COMMON/INPUT8/NNODES,NELEM,NNDF,INCREMENTS,ITERATIONS,LINEAR,
     .              SYMMETRIC,IDIM,NINODE
      COMMON/INPUTG/RESTART,OUTPUT_INTR,GRAPHICS_INTR,GRAPHICS_OUT
      COMMON/MEMO1/SKG(MAX_STORAGE)
      COMMON/MEMO2/SKGL(MAX_STORAGE)
      COMMON/IN_IO/I_OUT,I_IN,I_GRAPH
C
C       I_OUT   = OUTPUT DEVICE NUMBER
C       I_IN    = INPUT DEVICE NUMBER
C       I_GRAPH = GRAPHICAL OUTPUT DEVICE NUMBER
C
      I_GRAPH = 4
      I_IN  = 11
      I_OUT = 13
      DELETE=.TRUE.
      IN_FN=' '
      OUT_FN=' '
      GRAPH_FN=' '
C
C     THE FOLLOWING 5 LINES OF CODE ARE MICROSOFT FORTRAN SPECIFIC
C
      NUMARGS=NARGS()            ! MICROSOFT FORTRAN
      IF(NUMARGS.GE.2) CALL GETARG(1,RESPONSE,ARGSTAT)
      IF(NUMARGS.GE.3) CALL GETARG(2,IN_FN,ARGSTAT)
      IF(NUMARGS.GE.4) CALL GETARG(3,OUT_FN,ARGSTAT)
      IF(NUMARGS.GE.5) CALL GETARG(4,GRAPH_FN,ARGSTAT)
C
C     THE FOLLOWING 5 LINES OF CODE ARE UNIX XL FORTRAN SPECIFIC
C
C     NUMARGS=IARGC() + 1        ! UNIX IBM XL FORTRAN
C     IF(NUMARGS.GE.2) CALL GETARG(1,RESPONSE)
C     IF(NUMARGS.GE.3) CALL GETARG(2,IN_FN)
C     IF(NUMARGS.GE.4) CALL GETARG(3,OUT_FN)
C     IF(NUMARGS.GE.5) CALL GETARG(4,GRAPH_FN)
      IF(NUMARGS.GE.2) GOTO 5
      WRITE(*,'(1X,A,$)')'(D)elete or (K)eep intermediate files '//
     .         'after successful run [D]> '
      READ(*,'(A)',ERR=10)RESPONSE
5     IRES=STR$COLLAPSE(RESPONSE,RESPONSE)
      DELETE=RESPONSE(1:1) .NE. 'K' .AND. RESPONSE(1:1) .NE. 'k'
10    IF(DELETE)FILESTAT='DELETE'
      IF(.NOT.DELETE)FILESTAT='KEEP'
C
C     OPEN ALL I/O DEVICES
C
      OPEN(LDEV1,FILE='ldev1.dat',FORM='UNFORMATTED',STATUS='UNKNOWN')
      OPEN(LDEV2,FILE='ldev2.dat',FORM='UNFORMATTED',STATUS='UNKNOWN')
      OPEN(LDEVST,FILE='ldevst.dat',FORM='FORMATTED',STATUS='UNKNOWN')
      OPEN(I_IN,FILE=IN_FN,FORM='FORMATTED',STATUS='OLD',ERR=20)
      GOTO 25
20    IF(NUMARGS.GT.2) THEN
        WRITE(*,*) '!!!! USAGE ERROR'
        WRITE(*,*) 'USAGE: DNA_ALL [delstat] [input] [data output] '//
     .             '[graphics output]'
        WRITE(*,*) '  where - delstat: y/n response to delete '//
     .             'intermediate files'
        WRITE(*,*) '          input  : name of input data file '
        WRITE(*,*) '      data output: name of output file for '//
     .             'numerical data'
        WRITE(*,*) '  graphics output: name of output file for '//
     .             'graphical data'
        STOP
      ENDIF
22    WRITE(*,'(1X,A,$)')'Error opening input file. Enter new name> '
      READ(*,'(A)')IN_FN
      OPEN(I_IN,FILE=IN_FN,FORM='FORMATTED',STATUS='OLD',ERR=22)
      IF(NUMARGS.GT.3) GOTO 25
      IFILEN=STR$COLLAPSE(IN_FN,IN_FN)
      IEXT=STR$FIND_FIRST_IN_SET_R(IN_FN(:IFILEN),'.')-1
      IF(IEXT.LE.0)IEXT=IFILEN
      OUT_FN=IN_FN(:IEXT)//'.out'
      GRAPH_FN=IN_FN(:IEXT)//'.ps'
      LFOLEN=STR$COLLAPSE(OUT_FN,OUT_FN)
      LFGLEN=STR$COLLAPSE(GRAPH_FN,GRAPH_FN)
      PRINT*,'DATA OUTPUT FILE SET TO: '//OUT_FN(:LFOLEN)
      PRINT*,'GRAPHICS OUTPUT FILE SET TO: '//GRAPH_FN(:LFGLEN)
25    OPEN(I_OUT,FILE=OUT_FN,FORM='FORMATTED',STATUS='UNKNOWN',ERR=30)
      GOTO 35
30    WRITE(*,'(1X,A,$)')'Error opening output file. Enter new name> '
      READ(*,'(A)')OUT_FN
      OPEN(I_OUT,FILE=OUT_FN,FORM='FORMATTED',STATUS='UNKNOWN',ERR=30)
C
C       READ THE INPUT FILE
C
35    CALL INPUT(IDOF)
      CLOSE(I_IN,STATUS='KEEP')
      IF (NINODE.GT.0) THEN
        CALL HERMIT
        CALL COEFIC
      END IF
C
C       INITIATE THE PLOTTING ROUTINES
C
      IF (GRAPHICS_INTR.GT.0) THEN
        OPEN(I_GRAPH,FILE=GRAPH_FN,FORM='FORMATTED',STATUS='UNKNOWN',
     .       ERR=40)
        GOTO 45
40      WRITE(*,'(1X,A,$)')'Error opening graphics output file.'//
     .                     ' Enter new name> '
        READ(*,'(A)')GRAPH_FN
        OPEN(I_GRAPH,FILE=GRAPH_FN,FORM='FORMATTED',STATUS='UNKNOWN',
     .       ERR=40)
45      CALL INPLOT( NELEM )
      END IF
C     INITIATE TIMING OF SOLUTION (MICROSOFT FORTRAN; NEXT 3 LINES)
      CALL GETDAT(IYR,IMON,IIDAY)
      CALL GETTIM(IHOUR,IMIN,ISEC,IHSEC)
      INITIAL_TIME=IHOUR*3600.0+IMIN*60+ISEC+IHSEC/100.0
C
C       DEFINE THE GLOBAL DEGREES OF FREEDOM
C
      CALL GLOB1(NNODES,NNDF,NTDF,IDOF)
C
C       FIND THE BANDWIDTH AND THE LOCATION OF THE DIAGONAL TERMS
C       IN THE GLOBAL STIFFNESS MATRIX
C
      CALL DIAGNL(NELEM,NNDF,NTDF,IDOF,JDIAG,NTSK,MBAND,SYMMETRIC,I_OUT)
C
C       ASSEMBLE THE LOAD VECTOR
C
      CALL LOAD(R)
C
C       CALL THE SOLUTION CONTROL UNIT
C
      CALL CONTRL(SKG,SKGL,R,IDOF,JDIAG,NTSK,NTDF,I_OUT,MBAND)
C     TERMINATE TIMING OF SOLUTION (MICROSOFT FORTRAN; NEXT 12 LINES)
      CALL GETDAT(IYR,IMON,IFDAY)
      CALL GETTIM(IHOUR,IMIN,ISEC,IHSEC)
      IF(IFDAY.NE.IIDAY) THEN
        IHOUR=IHOUR+24
        IMIN=IMIN+60
      ENDIF
      FINAL_TIME=IHOUR*3600+IMIN*60+ISEC+IHSEC/100.0
      SOLUTION_TIME=FINAL_TIME-INITIAL_TIME
      IHOUR=INT(SOLUTION_TIME)/3600
      IMIN=(INT(SOLUTION_TIME)-IHOUR*3600)/60
      ISEC=INT(SOLUTION_TIME)-IHOUR*3600-IMIN*60
      IHSEC=(SOLUTION_TIME-INT(SOLUTION_TIME))*100
C     (UNIX XL FORTRAN; NEXT 5 LINES)
C     ISOLTIME=MCLOCK()
C     IHOUR=ISOLTIME/(3600*100)
C     IMIN=(ISOLTIME-IHOUR*3600*100)/(60*100)
C     ISEC=(ISOLTIME-IHOUR*3600*100-IMIN*60*100)/100
C     IHSEC=ISOLTIME-IHOUR*3600*100-IMIN*60*100-ISEC*100
      WRITE(I_OUT,'(1X,''CPU USAGE: '',I2,'':'',I2.2,'':'',I2.2,
     .      ''.'',I2.2,'' hrs'')')IHOUR,IMIN,ISEC,IHSEC
      WRITE(*,'(1X,''CPU USAGE: '',I2,'':'',I2.2,'':'',I2.2,
     .      ''.'',I2.2,'' hrs'')')IHOUR,IMIN,ISEC,IHSEC
C
C       CLOSE THE PLOT FILES
C
      IF(GRAPHICS_INTR.GT.0) CALL EOJOB
C
100   CLOSE(I_OUT,STATUS='KEEP')
      CLOSE(I_GRAPH,STATUS='KEEP')
      CLOSE(LDEV1,STATUS=FILESTAT)
      CLOSE(LDEV2,STATUS=FILESTAT)
      CLOSE(LDEVST,STATUS=FILESTAT)
C
      END
